#ifndef _PICTURE_CTRL_H_
#define _PICTURE_CTRL_H_

#include "ImageSplitter.h"
#include "ViewImageExampleRes.h"

#define STR_DLG_NAME				"Image Viewer"
#define GRAPH_FILE_1				"\Graph\Graph1.bmp"
#define GRAPH_FILE_2				"\Graph\Graph2.bmp"

class ViewImageSplitterDlg : public ResizeDialog
{
public:
	ViewImageSplitterDlg();
	~ViewImageSplitterDlg();
	
	int DoModal(HWND hWnd = NULL)
	{
		InitMsgMap();
		
		DWORD dwDlgOptions = 0;
		int nRet = ResizeDialog::DoModal(hWnd, dwDlgOptions);
		if(nRet != IDCANCEL)
		{
		}
		return nRet;
	}
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
EVENTS_END
	
	BOOL OnInitDialog();
	BOOL OnDestroy();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnClickOK();
	BOOL OnClickCancel();
	BOOL OnReady();
	
private:
	ImageSplitter	m_splitter; 
	Button			m_btnOK;
	Button			m_btnCancel;
};


#endif //_PICTURE_CTRL_H_